import { StyleSheet, View, FlatList, Button } from 'react-native';
import { useState } from 'react';

import GoalItem from './components/GoalItem'
import GoalInput from './components/GoalInput'


export default function App() {
  const [modelIsVisible, setModelIsVisible] = useState(false)
  const [goalsList, setGoalList] = useState([])

  function StartAddGoalHandler() {
    setModelIsVisible(true)
  }

  function handleCloseModal() {
    setModelIsVisible(false);
  }
  
  function handleGoalInput(input) {
    setGoalList(prevList => [
        ...prevList,
        {id : Math.random().toString(), value: input}
      ])    
  }

  function handleDeleteGoal(id) {
    setGoalList(prevList => {
      return prevList.filter((goal) => goal.id !== id)
    })
  }

  return (
    <View style={styles.container}>
      <Button title="Add New Goal" onPress={StartAddGoalHandler}/>
      <GoalInput onDataReceived={handleGoalInput} visible={modelIsVisible} onCloseModal={handleCloseModal}/>      
      <View style={styles.listContainer}>
        <FlatList 
          data={goalsList}
          renderItem={(itemData) => {
            return <GoalItem text={itemData.item} onDeleteItem={handleDeleteGoal}/>
          }}
          keyExtractor={(item, index) => {
            return item.id
          }}
          alwaysBounceVertical={false}
        />
      </View>
    </View>
  );
}

const styles = StyleSheet.create({
  container: {
    flex: 1,
    backgroundColor: '#fff',
    alignItems: 'center',
    justifyContent: 'center',
    paddingTop: 45
  },
  listContainer:{
    flex:4,
    width:'100%',
    padding: 15
  },
  
 
});
