import { View, TextInput, Button, StyleSheet, Modal } from 'react-native';
import { useState } from 'react';

function GoalInput(props) {
  const [goalInput, setGoalInput] = useState('');

  function handleGoalInput(enteredText) {
    setGoalInput(enteredText);
  }

  function handleAddGoal() {
    props.onDataReceived(goalInput);
    setGoalInput(''); 
    props.onCloseModal(); 
  }

  return (
    <Modal visible={props.visible} animationType="slide">
      <View style={styles.inputContainer}>
        
        <TextInput
          style={styles.input}
          placeholder="Type something"
          onChangeText={handleGoalInput}
          value={goalInput}
        />
        <Button title="Add Goal" onPress={handleAddGoal} />
      </View>
    </Modal>
  );
}

export default GoalInput;

const styles = StyleSheet.create({
  inputContainer: {
    flex: 1,
    justifyContent: 'center', // Center the input vertically in the modal
    alignItems: 'center',
  },
  input: {
    borderColor: '#ccc',
    borderBottomWidth: 1,
    width: '80%',
    marginBottom: 20,
    padding: 8,
  },
});
