import { Text, StyleSheet, Pressable } from 'react-native';

function GoalItem({ text, onDeleteItem }) {
  return (
    <Pressable android_ripple={{color: '#ddd'}}  onPress={onDeleteItem.bind(this, text.id)} style={({pressed}) => pressed && styles.pressedItem}>
      <Text style={styles.listDsn}>{text.value} {text.id}</Text>
    </Pressable>
  );
}

export default GoalItem;

const styles = StyleSheet.create({
 listDsn: {
    marginBottom: 100, 
    fontSize: 16, 
    color: '#333', 
  },
  pressedItem: {
    opacity : 0.5
  }
})